clc
clear
close all

Rx = @(alpha) [
    1, 0, 0;
    0, cos(alpha), -sin(alpha);
    0, sin(alpha), cos(alpha)];

Ry = @(alpha) [
    cos(alpha), 0, sin(alpha);
    0, 1, 0;
    -sin(alpha), 0, cos(alpha)];

Rz = @(alpha) [
    cos(alpha), -sin(alpha), 0;
    sin(alpha), cos(alpha), 0
    0, 0, 1];

load('hand_model.mat');
[centers, radii, blocks, theta, phalanges, mean_centers] = read_cpp_model('C:\Users\remelli\Desktop\fitting_cpp_initialization\anastasia\stage1\9\');

% transform from my orientation to htrack's one
R = Rx(-pi/2)*Rz(-pi);
% transform from htrack's orientation to mine
Rinv = Rz(pi) * Rx(pi/2);

for i = 1:length(centers)
    centers{i} = Rinv * centers{i};
end

%READ INITIAL TRANSFORMATIONS from htrack
hand_model.segments{1}{1}.local(1:3,1:3) = Rinv* phalanges{2}.local(1:3,1:3)*R;
hand_model.segments{1}{2}.local(1:3,1:3) = Rinv* phalanges{3}.local(1:3,1:3)*R;
hand_model.segments{1}{3}.local(1:3,1:3) = Rinv* phalanges{4}.local(1:3,1:3)*R;

hand_model.segments{5}{1}.local(1:3,1:3) = Rinv*  phalanges{5}.local(1:3,1:3)*R;
hand_model.segments{5}{2}.local(1:3,1:3) =  Rinv*  phalanges{6}.local(1:3,1:3)*R;
hand_model.segments{5}{3}.local(1:3,1:3) =  Rinv*  phalanges{7}.local(1:3,1:3)*R;

hand_model.segments{4}{1}.local(1:3,1:3) = Rinv*  phalanges{8}.local(1:3,1:3)*R;
hand_model.segments{4}{2}.local(1:3,1:3) =  Rinv*  phalanges{9}.local(1:3,1:3)*R;
hand_model.segments{4}{3}.local(1:3,1:3) =  Rinv*  phalanges{10}.local(1:3,1:3)*R;

hand_model.segments{3}{1}.local(1:3,1:3) = Rinv*  phalanges{11}.local(1:3,1:3)*R;
hand_model.segments{3}{2}.local(1:3,1:3) =  Rinv*  phalanges{12}.local(1:3,1:3)*R;
hand_model.segments{3}{3}.local(1:3,1:3) =  Rinv*  phalanges{13}.local(1:3,1:3)*R;

hand_model.segments{2}{1}.local(1:3,1:3) = Rinv*  phalanges{14}.local(1:3,1:3)*R;
hand_model.segments{2}{2}.local(1:3,1:3) =  Rinv*  phalanges{15}.local(1:3,1:3)*R;
hand_model.segments{2}{3}.local(1:3,1:3) =  Rinv*  phalanges{16}.local(1:3,1:3)*R;

% POSE MODEL
dtheta = { +[-theta(11); +theta(10); -theta(12:13)],[-theta(15); +theta(14); -theta(16:17)],-[+theta(19); -theta(18); +theta(20:21)],-[+theta(23); -theta(22); +theta(24:25)],-[+theta(27); -theta(26);+ theta(28:29)]};
hand_model.global_pose = [Rinv,zeros(3,1),;zeros(1,3),1] * makehgtform('translate',theta(1:3))*makehgtform('axisrotate', [1;0;0], theta(4))*makehgtform('axisrotate', [0;1;0], theta(5))*makehgtform('axisrotate', [0;0;1], theta(6))*[R,zeros(3,1),;zeros(1,3),1];
hand_model.global_translation = hand_model.global_pose(1:3,4);
% this should be improved, but should not really cause any problem like that
hand_model.global_rotation = [-theta(4);theta(5);theta(6)];
hand_model.theta = dtheta;
pose.global_translation = zeros(3,1);
pose.global_rotation = zeros(3,1);
hand_model = pose_model(hand_model, dtheta, pose);


%% DISPLAY MODEL

display_model_debug(centers,blocks,radii, 1.0, 'big')
display_model(hand_model,1.0,'big')