clc
clear
close all
addpath(genpath('../'))

%% LOAD HAND MODEL

load('hand_model.mat');

%% DISPLAY HAND MODEL

display_model(hand_model, 0.9, 'big')


 %% GENERATE DATA POINTS
 
downscaling = 12;
view_axis = 'Y';
sigma_noise = 0.0;

% Generate target model

target_hand_model = hand_model;

% perturbate finger info
sigma_radii = 1.0;
sigma_beta = 5.0;
sigma_theta = 0.4;

% displace fingers
for i = 1 : length(target_hand_model.finger_radii)
    target_hand_model.finger_radii{i} = target_hand_model.finger_radii{i} + sigma_radii*rand;
end

for i = 1:5
    target_hand_model.beta{i} = target_hand_model.beta{i} + sigma_beta* (2*rand(size( hand_model.beta{i})) -1);
    target_hand_model.theta{i} = target_hand_model.theta{i} + sigma_theta* [2*rand-1;0;2*rand(2,1)-1];
end

% displace palm
for i = 1 : 14
    target_hand_model.palm_wrist_centers{i} = target_hand_model.palm_wrist_centers{i} + 4*(rand(3,1) - 1);
    target_hand_model.palm_wrist_radii{i} = target_hand_model.palm_wrist_radii{i} + sigma_radii*rand;
end

target_finger_center = {zeros(3,1), zeros(3,1), zeros(3,1), zeros(3,1), zeros(3,1)};

[ target_hand_model.segments ] = update_fingers_shape(target_hand_model.segments, target_hand_model.beta );
[ target_hand_model.segments ] = update_fingers_pose(target_hand_model.segments, target_hand_model.joints, target_hand_model.theta, target_finger_center );
[ target_hand_model ] = update_membranes( target_hand_model );


data_points = generate_synthetic_point_cloud(target_hand_model, downscaling,view_axis, sigma_noise);

%% VISUALIZE DATA POINTS

mypoints(data_points, [0.3, 0.8, 0.3], 20);
 