clc
clear
close all
%addpath(genpath('../'))
load('hand_model.mat');
[hand_model] = reindex_fullhand(hand_model);


%% PARAMTERS DEFINING ROUGH DEFORMATION OF TARGET HAND

scale_x = 1.2;
scale_y = 1.0;
scale_z = 1.1;
fat_factor = 1.0;
finger_length_factor = 1.1;
alpha = [scale_x; scale_y; scale_z];

%% ROTATE MODEL

pose.global_rotation = [pi/2;pi;0.0];     
pose.global_translation = zeros(3,1);

%  pose.global_rotation = zeros(3,1);
%  pose.global_translation = zeros(3,1);
 
delta_theta = {[-0.4;+0.;0.0;0.0], [-0.0;0.0;-0.0;-0.0], [0.0;0.00;0.0;-0.0], -[0.0;0.00;0.0;0.0], [-0.0;+0.0;0.0;0.0]};
for i = 1:5
    hand_model.theta{i} = hand_model.theta{i} + delta_theta{i};
end

[ hand_model ] = pose_model(hand_model, delta_theta,pose );
[ hand_model ] = update_membranes( hand_model );


%% UNIFORMLY DEFORM HAND

target_hand_model = hand_model;

target_pose.global_rotation = 0.0*rand(3,1);     
target_pose.global_translation = 0*rand(3,1); 

delta_theta = {zeros(4,1), zeros(4,1), zeros(4,1), zeros(4,1), zeros(4,1)};

target_hand_model.beta = { finger_length_factor*target_hand_model.beta{1}, finger_length_factor*target_hand_model.beta{2},  finger_length_factor*target_hand_model.beta{3}, finger_length_factor*target_hand_model.beta{4}, finger_length_factor*target_hand_model.beta{5} };

for j = 1:length(target_hand_model.finger_radii)
    target_hand_model.finger_radii{j} = fat_factor*target_hand_model.finger_radii{j};
end

for j = 1:length(target_hand_model.palm_wrist_radii)
    target_hand_model.palm_wrist_radii{j} = fat_factor*target_hand_model.palm_wrist_radii{j};
    target_hand_model.palm_wrist_centers_relative{j} = alpha.*target_hand_model.palm_wrist_centers_relative{j};
end
% update centers   
[ target_hand_model ] = update_centers(target_hand_model);

delta_finger_center = {(alpha-1).*target_hand_model.segments{1}{1}.local(1:3,4), (alpha-1).*target_hand_model.segments{2}{1}.local(1:3,4), (alpha-1).*target_hand_model.segments{3}{1}.local(1:3,4), (alpha-1).*target_hand_model.segments{4}{1}.local(1:3,4), (alpha-1).*target_hand_model.segments{5}{1}.local(1:3,4)};

% update shape
[ target_hand_model.segments ] = update_fingers_shape(target_hand_model.segments, target_hand_model.beta );    
% update model pose
[ target_hand_model ] = update_fingers_pose(target_hand_model, delta_theta, delta_finger_center );
[ target_hand_model ] = pose_model(target_hand_model, delta_theta,target_pose );
% update membranes
[ target_hand_model ] = update_membranes( target_hand_model );  


% PERTURBATE FINGER INFO

sigma_radii = 0.0;
sigma_beta = 0.0;
sigma_theta = 0.0;

for i = 1 : length(target_hand_model.finger_radii)
    target_hand_model.finger_radii{i} = target_hand_model.finger_radii{i} + sigma_radii*rand;
end

for i = 1:5
    target_hand_model.beta{i} = target_hand_model.beta{i} + sigma_beta* (2*rand(size( hand_model.beta{i})) -1);
    target_hand_model.theta{i} =  sigma_theta* [2*rand-1;0;2*rand(2,1)-1];    
end
%target_hand_model.theta{1} = target_hand_model.theta{1} + [-0.4;-0.3;0.0;0.0];

% % displace palm
for i = 1 : 13
    target_hand_model.palm_wrist_centers{i} = target_hand_model.palm_wrist_centers{i} + 3*(rand(3,1) - 1);
    target_hand_model.palm_wrist_radii{i} = target_hand_model.palm_wrist_radii{i} + sigma_radii*(2*rand-1);
end

% update centers   
[ target_hand_model ] = update_centers(target_hand_model);

target_finger_center = {zeros(3,1), zeros(3,1), zeros(3,1), zeros(3,1), zeros(3,1)};
[ target_hand_model.segments ] = update_fingers_shape(target_hand_model.segments, target_hand_model.beta );
[ target_hand_model ] = update_fingers_pose(target_hand_model, target_hand_model.theta, target_finger_center );
[ target_hand_model ] = update_membranes( target_hand_model );

%% GENERATE PC


downscaling = 1;
view_axis = 'Z';
sigma_noise = 0.0;

data_points = generate_synthetic_point_cloud(target_hand_model, downscaling,view_axis, sigma_noise);

%% RENDER

display_model(hand_model, 0.9, 'big')
mypoints(data_points, [0.3, 0.3, 0.3], 7);

ds = 1;
settings.fov = 15;
settings.H = 480/ds;
settings.W = 636/ds;
settings.D=3;
settings.sparse_data = false;
settings.RAND_MAX = 32767;
settings.side = 'front';
settings.view_axis = 'Z';
RENDER_TAN_PC(hand_model,data_points, settings )