clc
clear
close all


%% LOAD HAND MODEL

load('hand_model.mat');

%% DISPLAY HAND MODEL

display_model(hand_model, 0.9, 'big')

data_points = { [-75.0;-20;70.0] };

%% VISUALIZE DATA POINTS

mypoints(data_points, [0.3, 0.8, 0.3], 20);

%% PROJECT POINTS ON MODEL

[indices, model_points, block_indices] = compute_projections(data_points, hand_model);

%% VISUALIZE DATA POINTS PROJECTIONS

mypoints(model_points, [0.3, 0.3, 0.8], 20);
mylines(data_points, model_points, [0.85, 0.85, 0.85]);
 
 
[is_on_segment, i,j, segment_index ] = block_index2segment_id( hand_model, indices{1}, block_indices{1} )


full_block = hand_model.blocks{ block_indices{1}};

[ bool_is_on_membrane, is_membrane_center, membrane_index ] = is_on_membrane( hand_model, indices{1} , block_indices{1} )

[ ~,  ~, full_membrane_index ] = is_on_membrane( hand_model, full_block' , block_indices{1} )



