function  isLoopClosed( E )
%ISEIGENBLOCKROT Summary of this function goes here
%   Detailed explanation goes here

E12=E(1:3,4:6);
E13=E(1:3,7:9);
E23=E(4:6,7:9);


%Extracting relative rotations (2 options for each essential) 8 options in total: 
W=[0 -1 0;1 0 0 ;0 0 1];
[u12,d12,v12]=svd(E12);
E12=E12/d12(1,1);
[u12,d12,v12]=svd(E12);
[u13,d13,v13]=svd(E13);
E13=E13/d13(1,1);
[u13,d13,v13]=svd(E13);
[u23,d23,v23]=svd(E23);
E23=E23/d23(1,1);
[u23,d23,v23]=svd(E23);



R12_1=makeSign(u12*W*v12');
R12_2=makeSign(u12*W'*v12');

R13_1=makeSign(u13*W*v13');
R13_2=makeSign(u13*W'*v13');

R23_1=makeSign(u23*W*v23');
R23_2=makeSign(u23*W'*v23');

%out of the 8 options one should be identity:
disp('If E is consistent, out of the following 8 options, one should be identity')
R12_1*R23_1*R13_1'
R12_1*R23_1*R13_2'
R12_1*R23_2*R13_1'
R12_1*R23_2*R13_2'
R12_2*R23_1*R13_1'
R12_2*R23_1*R13_2'
R12_2*R23_2*R13_1'
R12_2*R23_2*R13_2'
end

