/*
 * Globally-Optimal Gaussian Mixture Alignment (GOGMA): config_map
 * Open and parse a config file.
 *
 * Campbell, D., and Petersson, L., "GOGMA: Globally-Optimal Gaussian
 * Mixture Alignment", IEEE Conference on Computer Visision and
 * Pattern Recognition (CVPR), Las Vegas, USA, IEEE, Jun. 2016
 *
 * For the full license, see license.txt in the root directory
 *
 * Author: Dylan Campbell
 * Date: 20160212
 * Revision: 1.1
 */

#ifndef CONFIGMAP_H
#define CONFIGMAP_H

#include <map>
#include <list>
#include <string>
#include <cstdlib>
#include <iostream>
#include <fstream>

#include "string_tokenizer.h"

class ConfigMap {

private:
  std::map<std::string,std::string> mappings;
  std::list<double*> double_allocated_memory_collector;
  std::list<int*> int_allocated_memory_collector;

public:
  ConfigMap();
  ConfigMap(const char* config_file);
  ~ConfigMap();

  // Adds a config line to the map
  void addLine(std::string line_);

  // Adds a key->value mapping
  void addPair(std::string key_, std::string value_);

  // Gets the string value at a given key
  char* get(char* key_);
  char* get(const char* key_);

  // Gets the integer value at a given key
  // (uses the stdlib function 'atoi' to convert)
  int getI(char* key_);
  int getI(const char* key_);

  // Gets the double value at a given key
  // (uses the stdlib function 'atof' to convert)
  double getF(char* key_);
  double getF(const char* key_);

  // Gets an array of integers at the given key
	int* getIArray(char* key_);
	int* getIArray(const char* key_);
	int* getIArray(char* key_, int& num_elements_);
	int* getIArray(const char* key_, int& num_elements_);

  // Gets an array of floats at the given key
	double* getFArray(char* key_);
	double* getFArray(const char* key_);
	double* getFArray(char* key_, int& num_elements_);
	double* getFArray(const char* key_, int& num_elements_);

  // Prints the contents of the map list to stdout
  void print();

};

#endif /* CONFIGMAP_H */
