/*
 * Globally-Optimal Gaussian Mixture Alignment (GOGMA): string_tokenizer
 * Parse strings from the config file.
 *
 * Campbell, D., and Petersson, L., "GOGMA: Globally-Optimal Gaussian
 * Mixture Alignment", IEEE Conference on Computer Visision and
 * Pattern Recognition (CVPR), Las Vegas, USA, IEEE, Jun. 2016
 *
 * For the full license, see license.txt in the root directory
 *
 * Author: Dylan Campbell
 * Date: 20160212
 * Revision: 1.1
 */

#ifndef STRINGTOKENIZER_H
#define STRINGTOKENIZER_H

#include <list>
#include <string>

class StringTokenizer {
private:
  std::list<std::string> tokens;

public:
  StringTokenizer();
  StringTokenizer(std::string str, char delim = ' ');
  StringTokenizer(std::string str, char * delims);
  ~StringTokenizer();

  std::string nextToken();
  bool hasMoreTokens();
  int numberOfTokens();
};

#endif /* STRINGTOKENIZER_H */
