%#ok<*NBRAK>
%#ok<*AGROW>
%#ok<*NASGU>
%#ok<*ASGLU>

function [remI,sol,total_runtime] = GORESynthetic(A,b,th,nocallback)

rng('shuffle');

% GORE parameters
M = 1000;   % Big-M.
T = 10;     % number of points to test
c = 15;     % Time per test.

% Initial estimate for upper bound.
tic;
    [out_upper_bound,ransac_sol] = ransac(A,b,th,10000);
runtime_ransac = toc;

r = abs(A*ransac_sol - b);
[~,I] = sort(r,'descend');

% GORE.
runtime_gore = zeros(1,T);
numrem_gore = zeros(1,T);
remI = []; % index of points identified as true outliers    
for t=1:T
    k = I(t); % start with the worst outliers to ransac estimate
        
    Ak = A(k,:);
    bk = b(k);
    At = A;
    bt = b;
    At([remI k],:) = [];
    bt([remI k]) = [];

    if nocallback
        tic;
            [lb_val,~,~] = milpFitLin(At,bt,th,M,c,0,Ak,bk);
        runtime = toc;
    else
        model = kmilpLinModel(At,bt,th,M,Ak,bk);
        tic;
            [lb_val,~,~] = maxcon_milp(model.vtype,model.A,model.sense,model.rhs,c,int32(out_upper_bound));
        runtime = toc;
    end
    
    if t == 1
        runtime_gore(t) = runtime;
    else
        runtime_gore(t) = runtime_gore(t-1) + runtime;
    end

    if lb_val > out_upper_bound
        remI = [remI k];
    end
    
    numrem_gore(t) = numel(remI);
    
    fprintf('GORE %d/%d: %d outlier(s) identified, total time elapsed: %f seconds.\n',t,T,length(remI),runtime_gore(t));
end

% Exact after GORE.
fprintf('Running MILP after preprocessing with GORE...\n');
At = A;
bt = b;
At(remI,:) = [];
bt(remI) = [];
tic;
    [lb,ub,sol] = milpFitLin(At,bt,th,M,inf,0,[],[]);
runtime_gored_exact = toc;
fprintf('MILP solved the pre-processed problem exactly in %f seconds.\n',runtime_gored_exact);

total_runtime = runtime_ransac + runtime_gore(end) + (runtime_gored_exact);

end