% arguments:
% N refers to the number of data points to generate
% p refers to the dimensionality of the model/estimate/parameter theta.
% inlier_sigma refers to the multiplier used as noise on inlier points.
% outlier_sigma refers to the multiplier used to generate outliers.
% outRation refers to the outlier ratio.
function [A,b,theta] = randLin(N,p,inlier_sigma,outlier_sigma,outRatio)
    if p <= 0
        error('p should be a positive integer!');
    end
    
    theta = myRand(3,1);
    
    A_mult = 1; % convert to a range between (-50,50)
    if p == 1
        A = A_mult*myRand(N,1);
    else
        A = [A_mult*myRand(N,p-1) ones(N,1)];
    end
    b = A*theta;
    
    outCount = floor(outRatio*N);
    
    inI = outCount+1:N; % inlier index
    b(inI) = b(inI) + inlier_sigma*randn(length(inI),1); % apply inlier noise
    
    outI = 1:outCount;
    b(outI) = b(outI) + outlier_sigma * myRand(length(outI),1); % apply iid to outliers
end

% returns a random number generally distributed between the range of [-1,1]
% implemented based on the matlab function rand.
function num = myRand(M,N)
    num = 0.5 - rand(M,N);
    num = num / 0.5;
end