function illustrate3d(A,b,th,remI,sol)
    figure();
    
    subplot(1,2,1);
    hold on;
    scatter3(A(:,1),A(:,2),b,'filled');
    scatter3(A(remI,1),A(remI,2),b(remI),300,'r');
    view(53,16);
    legend('All 3d points','True outliers removed by GORE','Location','southwest');
    legend('boxoff');
    grid on;
    hold off;
    
    subplot(1,2,2);
    hold on;
    r = abs(A*sol - b);
    outliers = find(r > th);
    % draw all points
    scatter3(A(:,1),A(:,2),b,'filled');
    scatter3(A(outliers,1),A(outliers,2),b(outliers),'filled','r');
    scatter3(A(remI,1),A(remI,2),b(remI),300,'r');
    % calculate coordinates for drawing plane
    coords = axis();
    X = [coords(1);coords(1);coords(2);coords(2)];
    Y = [coords(3);coords(4);coords(4);coords(3)];
    Z = [X Y ones(4,1)]*sol;
    fill3(X',Y',Z','r');
    alpha(0.3);
    view(53,16);
    legend('True inliers','True outliers','True outliers removed by GORE','The fitted plane','Location','southwest');
    legend('boxoff');
    grid on;
    hold off;
    
    rotate3d;
    set(gcf,'units','normalized','outerposition',[0 0 1 1])
    drawnow;
end