function illustrateAffine(match,th,remI,sol)

    filename1 = 'data/graf_img5.ppm';
    filename2 = 'data/graf_img6.ppm';
    img1 = imread(filename1);
    img2 = imread(filename2);
    img1 = imresize(img1,0.25);
    img2 = imresize(img2,0.25);
    
    max_y = max(size(img1,1),size(img2,1));
    if size(img1,1) < max_y
        img1(end+1:max_y,:,:) = 255;
    elseif size(img2,1) < max_y
        img2(end+1:max_y,:,:) = 255;
    end
    img1(:,end+1:end+3,:) = 255;
    canvas = img1;
    canvas = [canvas img2];
    
    canvas = rgb2gray(canvas);
    
    x_offset = size(img1,2);
    line_start_x = match(1,:);
    line_start_y = match(2,:);
    line_end_x = match(3,:) + x_offset;
    line_end_y = match(4,:);
    A = [line_start_x; line_end_x];
    B = [line_start_y; line_end_y];
    
    N = size(match,2);
    r_aff = reshape(sol,3,2);
    r = max(abs([match(1:2,:)' ones(N,1)]*r_aff - match(3:4,:)'),[],2);
    inliers = find(r - th <= eps('single'));
    outliers = find(r - th > eps('single'));
    
    figure();
    
    subplot(1,2,1);
    hold on;
    imshow(canvas);
    plot(A,B,'b-');
    plot(A(:,remI),B(:,remI),'y-');
    hold off;
    
    msg = sprintf('All matching feature points are show in the above image.\n');
    msg = sprintf('%sLines drawn in yellow are the true outliers identified by GORE.',msg);
    text(0,max(ylim),msg,'FontSize',14,'FontWeight','bold');
    
    subplot(1,2,2);
    hold on;
    imshow(canvas);
    plot(A(:,inliers),B(:,inliers),'g-');
%     plot(A(:,outliers),B(:,outliers),'r-');
    plot(A(:,remI),B(:,remI),'y-');
    hold off;
    
    msg = sprintf('True inliers to the maximum consensus set are shown in the above image.\n');
    msg = sprintf('%sLines drawn in yellow are the true outliers identified by GORE.',msg);
    text(0,max(ylim),msg,'FontSize',14,'FontWeight','bold');

    set(gcf,'units','normalized','outerposition',[0 0 1 1])
    drawnow;
end