function model = kmilpLinModel(X,y,th,M,Xk,yk)
    N = size(X,1);
    p = size(X,2);
    
    M_N = M*ones(N,1);

    f = [zeros(p,1);
          ones(N,1)];
    A = [ X -diag(M_N);
         -X -diag(M_N)];
    b = [th+y;
         th-y];
    
    A = [      A       ;
          Xk zeros(1,N);
         -Xk zeros(1,N)];
    b = [  b  ;
         th+yk;
         th-yk];
     
    model.A = A;
    model.obj = f;
    model.rhs = b;
    model.sense = repmat('<',2*N+2,1);
    model.vtype = [repmat('C',p,1);
                   repmat('B',N,1)];
    model.lb = [ -Inf(p,1);
                zeros(N,1)];
    model.ub = [  Inf(p,1);
                 ones(N,1)];
    model.modelsense = 'min';
    
    vtype = [sum(model.vtype=='C') sum(model.vtype=='B')];
    model.vtype = int32(vtype);
    sense = -ones(length(model.sense),1);
    for i = 1:length(model.sense)
        if model.sense(i) == '<'
            sense(i) = -1;
        elseif model.sense(i) == '>'
            sense(i) = 1;
        else
            error('unable to interpret model.sense');
        end
    end
    model.sense = int32(sense);
end