% dependency: randomsample.m

function [maxsize,maxpar,par,res] = ransacFitAffine(match,th,iter)

% Data parameters.
p = 6;
N = size(match,2);

A = [ match(1:2,:)' ones(N,1) ];
b = match(3:4,:)';

% RANSAC.
% iter = 10000;
res = zeros(N,iter);
par = zeros(p,iter);
for m=1:iter
    s = 1;
    while s==1
        inx = randomsample(N,p);
        Asub = A(inx,:);
        bsub = b(inx,:);
        if rcond(Asub'*Asub)>=100*eps
            s = 0;
        end
    end
    aff = Asub\bsub;
    par(:,m) = aff(:);
    res(:,m) = max(abs(A*aff-b),[],2);
end

csize = sum(res<=th);
[maxsize,maxinx] = max(csize);
maxpar = par(:,maxinx);

end