function [grad] = f_grad_L2(A1, A2, B1, B2, C, D, X) % done
% grad: [grad1, grad2, ... ];
% A1, ..., D: active a1 to d

% quotient rule: (f/g)' = (f'g - fg')/g^2
% since only the direction matters, we can neglect the positive denominator g^2


[active, d] = size(A1);
grad = zeros(d, active);
GX = (A1*X+B1).^2 + (A2*X+B2).^2;
for i = 1:active
    
    a1 = A1(i,:);
    a2 = A2(i,:);
    b1 = B1(i,:);
    b2 = B2(i,:);
    c = C(i,:);
    d = D(i,:);
    
    gx = GX(i);
    
    grad(:,i) = (c*X+d)/sqrt(gx) * ((a1*X+b1)*a1' + (a2*X+b2)*a2')  -  sqrt(gx)*c';
    
    grad(:,i) = grad(:,i)/norm(grad(:,i));

end

end
