function [ alpha, val, nitr ] = f_stepsize_L2( a1, a2, b1, b2, c, d, X, dir, Active, oldval, lb0, ub0, opt ) % done

tol1 = 1e-6;
tol2 = 1e-8;
n = size(a1,1);

if lb0>=ub0
    alpha = 0;
    val = oldval;
    return;
end
    
nitr = 0;    


% bisection on alpha
if opt==1
    ub = min(ub0,1e1);
    lb = max(0,lb0);
    r = (ub+lb)/2;
    alpha = lb;
    val = oldval;
    while ub-lb > tol1
        r = (ub+lb)/2;
        Xn = X + (r-tol2)*dir; % Xn is on the negative side of Xc
        Xp = X + (r+tol2)*dir;
        Xc = X + (r)*dir;
        vn = max( sqrt( ( (a1*Xn+b1).*(a1*Xn+b1) + (a2*Xn+b2).*(a2*Xn+b2) ) ./ ( (c*Xn+d).*(c*Xn+d) ) ) );
        vp = max( sqrt( ( (a1*Xp+b1).*(a1*Xp+b1) + (a2*Xp+b2).*(a2*Xp+b2) ) ./ ( (c*Xp+d).*(c*Xp+d) ) ) );
        vc = max( sqrt( ( (a1*Xc+b1).*(a1*Xc+b1) + (a2*Xc+b2).*(a2*Xc+b2) ) ./ ( (c*Xc+d).*(c*Xc+d) ) ) );
        if vn > vc && vc > vp % increase r
            lb = r;
        elseif vn < vc && vc < vp % decrease r
            ub = r;
        else
            alpha = r;
            val = vc;
            break;
        end
    end
    alpha = r;
    val = vc;
end
